/*
 * Decompiled with CFR 0.152.
 */
package slimeknights.tconstruct.plugin.rei.modifiers;

import java.util.List;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.display.Display;
import me.shedaniel.rei.api.common.display.SimpleDisplaySerializer;
import me.shedaniel.rei.api.common.entry.EntryIngredient;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.util.EntryIngredients;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import slimeknights.tconstruct.library.recipe.modifiers.adding.IDisplayModifierRecipe;
import slimeknights.tconstruct.library.tools.SlotType;
import slimeknights.tconstruct.plugin.rei.TConstructREIConstants;

public class ModifierRecipeDisplay
implements Display {
    private final List<EntryIngredient> inputEntries;
    private final List<EntryIngredient> outputEntries;
    private final boolean hasRequirements;
    private final boolean isIncremental;
    private final int maxLevel;
    private final SlotType.SlotCount slots;
    private final String requirementsError;
    private final EntryIngredient toolWithoutModifier;
    private final EntryIngredient toolWithModifier;

    public ModifierRecipeDisplay(IDisplayModifierRecipe recipe) {
        this(List.of(EntryIngredients.ofItemStacks(recipe.getDisplayItems(0)), EntryIngredients.ofItemStacks(recipe.getDisplayItems(1)), EntryIngredients.ofItemStacks(recipe.getDisplayItems(2)), EntryIngredients.ofItemStacks(recipe.getDisplayItems(3)), EntryIngredients.ofItemStacks(recipe.getDisplayItems(4))), List.of(EntryIngredient.of((EntryStack)EntryStack.of(TConstructREIConstants.MODIFIER_TYPE, (Object)recipe.getDisplayResult()))), recipe.hasRequirements(), recipe.isIncremental(), recipe.getMaxLevel(), recipe.getSlots(), recipe.getRequirementsError(), EntryIngredients.ofItemStacks(recipe.getToolWithoutModifier()), EntryIngredients.ofItemStacks(recipe.getToolWithModifier()));
    }

    public ModifierRecipeDisplay(List<EntryIngredient> inputEntries, List<EntryIngredient> outputEntries, boolean hasRequirements, boolean isIncremental, int maxLevel, SlotType.SlotCount slots, String requirementsError, EntryIngredient toolWithoutModifier, EntryIngredient toolWithModifier) {
        this.inputEntries = inputEntries;
        this.outputEntries = outputEntries;
        this.hasRequirements = hasRequirements;
        this.isIncremental = isIncremental;
        this.maxLevel = maxLevel;
        this.slots = slots;
        this.requirementsError = requirementsError;
        this.toolWithoutModifier = toolWithoutModifier;
        this.toolWithModifier = toolWithModifier;
    }

    public CategoryIdentifier<ModifierRecipeDisplay> getCategoryIdentifier() {
        return TConstructREIConstants.MODIFIERS;
    }

    public boolean hasRequirements() {
        return this.hasRequirements;
    }

    public boolean isIncremental() {
        return this.isIncremental;
    }

    public int getMaxLevel() {
        return this.maxLevel;
    }

    public SlotType.SlotCount getSlots() {
        return this.slots;
    }

    public String getRequirementsError() {
        return this.requirementsError;
    }

    public EntryIngredient getToolWithoutModifier() {
        return this.toolWithoutModifier;
    }

    public EntryIngredient getToolWithModifier() {
        return this.toolWithModifier;
    }

    public List<EntryIngredient> getInputEntries() {
        return this.inputEntries;
    }

    public List<EntryIngredient> getOutputEntries() {
        return this.outputEntries;
    }

    public static class Serializer
    implements SimpleDisplaySerializer<ModifierRecipeDisplay> {
        public class_2487 saveExtra(class_2487 tag, ModifierRecipeDisplay display) {
            tag.method_10556("hasRequirements", display.hasRequirements());
            tag.method_10556("isIncremental", display.isIncremental());
            tag.method_10569("maxLevel", display.getMaxLevel());
            class_2487 slotsTag = new class_2487();
            display.getSlots().write(slotsTag);
            tag.method_10566("slots", (class_2520)slotsTag);
            tag.method_10582("requirements_error", display.getRequirementsError());
            tag.method_10566("tool_without_modifier", (class_2520)display.toolWithoutModifier.saveIngredient());
            tag.method_10566("tool_with_modifier", (class_2520)display.toolWithModifier.saveIngredient());
            return tag;
        }

        public ModifierRecipeDisplay read(class_2487 tag) {
            List input = EntryIngredients.read((class_2499)tag.method_10554("input", 9));
            List output = EntryIngredients.read((class_2499)tag.method_10554("output", 9));
            boolean hasRequirements = tag.method_10577("hasRequirements");
            boolean isIncremental = tag.method_10577("isIncremental");
            int maxLevel = tag.method_10550("maxLevel");
            SlotType.SlotCount slots = SlotType.SlotCount.read(tag.method_10562("slots"));
            String requirementsError = tag.method_10558("requirements_error");
            EntryIngredient toolWithoutModifier = EntryIngredient.read((class_2499)tag.method_10554("tool_without_modifier", 9));
            EntryIngredient toolWithModifier = EntryIngredient.read((class_2499)tag.method_10554("tool_with_modifier", 9));
            return new ModifierRecipeDisplay(input, output, hasRequirements, isIncremental, maxLevel, slots, requirementsError, toolWithoutModifier, toolWithModifier);
        }
    }
}

